function [Coeff_table, co2effect, scrubeffect, allocation, areas, price, share_other, total_endog_area ] = LUCM1_load_data(pixel_size )
%
% Land Use Change Module - function 1 (LUCM1)
%
% This file loads coefficients and explanitory variables. These are used to
% estimate future land use shares. Some historical values are also loaded
% for producing figures of change over time.
%

% Code by Simon Anastasiadis : 2011-11-01
% Coefficients require updating as at 2011-11-01

%% Parameters

% first year of simulation
start_year = 2009;

% info for loading intensity module coefficients
% coefficent file
intensity_coef_file = '..\Data for Modules\Data 3 Land Use Intensity Module\coefficients Timar 2012.xlsx';
% sheet names
dairy_sheet_name = 'dairy';
sheep_sheet_name = 'sheepbeef';
% coefficient ranges
dairy_GHG_per_Lmilk_range = 'D2:G2';
dairy_Lmilk_per_MS_range = 'D3:G3';
SB_SU_ratio_range = 'D20:G20';
sheep_GHG_per_SU_range = 'D34:G34';
beef_GHG_per_SU_range = 'D37:G37';
% specified according to instructions in xlsread file (supporting code)
% call: "help xlsread" from Matlab prompt

%% Load coefficients and CO2 values

% file to load from
loadfile = '..\Data for Modules\Data 1 Land Use Change Module\Coefficients and CO2.xlsx';

% load table of coefficients
[Coeff_table, ~] = xlsread(loadfile, 'Coefficients');

% load carbon price information
[CO2eq_table , ~] = xlsread(loadfile, 'CO2');

% load free allocation information
[Alloc_table, ~] = xlsread(loadfile, 'Free allocation');

%% Load time trends in land use areas, prices and interest rates

% file to load from
loadfile = '..\Data for Modules\Data 1 Land Use Change Module\Area and Prices.xlsx';

% load historical areas
[Areas_table, ~] = xlsread(loadfile, 'Historical Area');

% load price trends
[Price_table, ~] = xlsread(loadfile, 'Prices');

%% Format Carbon price values

% Carbon prices store as structure
co2effect.dairy = CO2eq_table(1);
co2effect.sheep = CO2eq_table(2);
co2effect.forest = CO2eq_table(3);

% Scrub effects store as structure
scrubeffect.dairy = CO2eq_table(6);
scrubeffect.sheep = CO2eq_table(7);
scrubeffect.forest = CO2eq_table(8);

% free allocation table
allocation.year = Alloc_table(:,1);
allocation.dairyfree  = Alloc_table(:,2);
allocation.dairy2for1 = Alloc_table(:,3);
allocation.sheepfree  = Alloc_table(:,4);
allocation.sheep2for1 = Alloc_table(:,5);

%% Format areas, prices and interest rates

% share of other area
share_other = Areas_table(end,7)/Areas_table(end,2);

% Areas structure to store area data
areas.year  = Areas_table(:,1);
areas.dairy = Areas_table(:,3);
areas.sheep = Areas_table(:,4);
areas.forest = Areas_table(:,5);
areas.scrub = Areas_table(:,6);

% Price structure to store price data
price.year = Price_table(:,1);
price.dairy = Price_table(:,2);
price.sheep = Price_table(:,3);
price.forest = Price_table(:,4);
price.interest = Price_table(:,5);

%% Total endogenous area

% file to load from
loadpath = '..\Data for Modules\Data 2 Land Use Allocation Module\';
loadfile = ['LUAM_input_data_',num2str(pixel_size),'ha.mat'];

load([loadpath,loadfile],'total_endog_area');

%% Inform User loading data is complete

msg = sprintf(' - - LUCM1 : loading data complete');
disp(msg)

end

%% Subfunction : Formula Value or Constant

function [values ] = formula_or_constant(coef, coef_years)
% Similar to subfunction in GHGM2 but gives vector output rather than scalar
% either length(coef) = 3
% 1. alpha
% 2. beta
% 3. gamma
% OR length(coef) = 1
% 1. constant

% Value = alpha + beta * Ln(year - gamma) or constant (whichever is provided).

% use constant if it is provided
if length(coef) == 1
    values = coef * ones(size(coef_years));
% otherwise use formula
else
    alpha = coef(1);
    beta = coef(2);
    gamma = coef(3);
    values = alpha + beta * log(coef_years - gamma);
end

end
